package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.CheckedException;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Date;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

@Entity
@DiscriminatorValue("3")
public class SoftwareRequest extends Request {

	SoftwareRequest() {}
	
	public SoftwareRequest(final String createdBy) throws ValidationException {
		super(createdBy);
	}
	
	public static SoftwareRequest create(final String createdBy) throws CheckedException {
		ValidationHelper.required("Created By", createdBy);
		
		SoftwareRequest result = new SoftwareRequest(createdBy);
		result.setCreatedOn(new Date());
		result.workflowId = 0;
		result.workflowState = 0;
		result.workflowMask = 0L;
		
		result.validateModify();
		
		DartObjectFactory.getInstance().getSoftwareRequestDAO().save(result);
		
		return result;
	}

	private void validateModify() throws CheckedException {
		
	}

}
